#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/fw_env.config.new

( cd usr/sbin ; rm -rf fw_setenv )
( cd usr/sbin ; ln -sf fw_printenv fw_setenv )
( cd usr/sbin ; rm -rf sheeva-ubootenv-encode )
( cd usr/sbin ; ln -sf sheeva-ubootenv-decode sheeva-ubootenv-encode )
( cd usr/sbin ; rm -rf sheeva-nandrs-encode )
( cd usr/sbin ; ln -sf sheeva-nandrs-decode sheeva-nandrs-encode )
