config() {
  NEW="$1"
  OLD="$(dirname $NEW)/$(basename $NEW .new)"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
for conffile in \
  Xaccess Xreset Xresources Xservers Xsession Xsetup_0 Xstartup Xwilling \
  GiveConsole TakeConsole chooser xdm-config ../app-defaults/Chooser ;
do
  config etc/X11/xdm/${conffile}.new
done

( cd usr/lib/X11 ; rm -rf xdm )
( cd usr/lib/X11 ; ln -sf ../../../etc/X11/xdm xdm )
